from wiki.api_v2.exceptions import BadRequest, NotFound


class BookmarkNotFound(NotFound):
    error_code = 'BOOKMARK_NOT_FOUND'


class TagNotFound(NotFound):
    error_code = 'TAG_NOT_FOUND'


class TagLimitExceeded(BadRequest):
    error_code = 'TAG_LIMIT_EXCEEDED'


class BookmarkLimitExceeded(BadRequest):
    error_code = 'BOOKMARK_LIMIT_EXCEEDED'
