from wiki.api_v2.collections import Collection
from wiki.api_v2.public.me.favorites.views import (
    autobookmarks_view,
    bookmarks_view,
    create_bookmark_view,
    create_tags_view,
    delete_bookmark_view,
    delete_tags_view,
    update_bookmark_view,
    tags_view,
)
from wiki.api_v2.public.me.favorites.schemas import (
    AutoBookmarkSchema,
    BookmarkSchema,
    CreateTagResponse,
    TagSchema,
)
from wiki.api_v2.schemas import DELETED_RESPONSE


def inject_favorites_routes(router, tags, prefix='favorites'):
    router.get('favorites', response=Collection[BookmarkSchema], tags=tags)(bookmarks_view)
    router.post('favorites', response=BookmarkSchema, tags=tags)(create_bookmark_view)
    router.post('favorites/{int:idx}', response=BookmarkSchema, tags=tags)(update_bookmark_view)
    router.delete('favorites/{int:idx}', response=DELETED_RESPONSE, tags=tags)(delete_bookmark_view)

    router.get('favorites/tags', response=Collection[TagSchema], tags=['me/favorites/tags'])(tags_view)
    router.post('favorites/tags', response=CreateTagResponse, tags=['me/favorites/tags'])(create_tags_view)
    router.delete('favorites/tags', response=DELETED_RESPONSE, tags=['me/favorites/tags'])(delete_tags_view)

    router.get('autobookmarks', tags=['me'], response=Collection[AutoBookmarkSchema])(autobookmarks_view)
