from datetime import datetime
from ninja import Schema
from pydantic import constr
from typing import List, Optional

from wiki.api_v2.public.pages.page_identity import PageIdentity
from wiki.api_v2.public.pages.schemas import UserSchema
from wiki.favorites.consts import AutoBookmarkType

Tag = constr(min_length=1, max_length=50)


class TagSchema(Schema):
    id: int
    name: Tag


class BookmarkPageSchema(Schema):
    id: int
    title: str
    slug: str
    author: UserSchema
    modified_at: datetime
    created_at: datetime
    is_active: bool


class AutoBookmarkSchema(Schema):
    id: int
    page: BookmarkPageSchema
    bookmark_type: AutoBookmarkType
    created_at: datetime


class BookmarkSchema(Schema):
    id: int
    page: BookmarkPageSchema
    tags: List[TagSchema]
    created_at: datetime


class CreateBookmarkSchema(Schema):
    page: PageIdentity
    tags: Optional[List[Tag]]


class CreateDeleteTagSchema(Schema):
    tags: List[Tag]


class UpdateBookmarkSchema(Schema):
    tags: List[Tag]


class CreateTagResponse(Schema):
    results: List[TagSchema]
