from typing import Optional

from ninja import Schema

from wiki.api_frontend.serializers.user_identity import UserIdentity
from wiki.api_v2.di import di
from wiki.personalisation.user_cluster import get_user_personal_cluster_slug
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.sync.connect.org_identity import OrganizationIdentity


class MeResponse(Schema):
    username: str
    home_cluster: Optional[str]
    identity: UserIdentity
    org: OrganizationIdentity


@di
def me_view(request, organization: BaseOrganization) -> MeResponse:
    return MeResponse(
        username=request.user.username,
        identity=UserIdentity.from_user(request.user),
        org=OrganizationIdentity.from_organization(organization),
        home_cluster=get_user_personal_cluster_slug(request.user),
    )
