from wiki.featured_pages.user_api.schemas import FeaturedPagesResponseSchema
from wiki.featured_pages.user_api.views import get_featured_pages_view
from wiki.api_v2.public.me.favorites.router import inject_favorites_routes
from wiki.api_v2.public.me.me_view import me_view, MeResponse
from wiki.api_v2.public.me.settings_view import (
    get_settings_view,
    patch_settings_view,
    reset_untyped_settings_view,
    UserSettingsSchema,
)
from wiki.api_v2.public.me.schemas import UserFeatureResponse
from wiki.api_v2.public.me.subscriptions.router import inject_subscriptions_routes
from wiki.api_v2.public.me.features_view import (
    disable_user_feature_view,
    enable_user_feature_view,
    get_user_features_view,
)
from wiki.api_v2.router_factory import make_public_api_router
from wiki.api_v2.schemas import StatusOk

me_router = make_public_api_router(['me'])

me_router.get('', response=MeResponse)(me_view)
me_router.get('/settings', response=UserSettingsSchema)(get_settings_view)
me_router.post('/settings')(patch_settings_view)
me_router.post('/reset_untyped_settings')(reset_untyped_settings_view)
me_router.get('/featured_pages', response=FeaturedPagesResponseSchema, exclude_unset=True)(get_featured_pages_view)
me_router.get('/features', response=UserFeatureResponse)(get_user_features_view)
me_router.post('/enable_feature', response=StatusOk)(enable_user_feature_view)
me_router.post('/disable_feature', response=StatusOk)(disable_user_feature_view)

inject_favorites_routes(me_router, tags=['me/favorites'])
inject_subscriptions_routes(me_router, ['me/subscriptions'], prefix='/subscriptions')
