from wiki.api_v2.di import di, legacy_org_ctx
from wiki.api_v2.public.me.subscriptions.schemas import MigrationSchema
from wiki.subscriptions.management.commands.logic_migration_from_page_watch import migrate_page_watches_to_subscriptions
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.api_v2.schemas import StatusOk


@di
@legacy_org_ctx
def migrate_view(request, organization: BaseOrganization, data: MigrationSchema) -> StatusOk:
    """Migration of the current user's subscriptions from the PageWatch model to Subscription model"""
    migrate_page_watches_to_subscriptions(user=request.user, org=organization.as_django_model(), force=data.force)
    return StatusOk()
