from wiki.api_v2.collections import Collection
from wiki.api_v2.public.me.subscriptions.mirgate import migrate_view
from wiki.api_v2.public.me.subscriptions.schemas import SubscriptionSchema
from wiki.api_v2.public.me.subscriptions.views import (
    create_subscription_view,
    delete_subscriptions_view,
    get_subscriptions_view,
)
from wiki.api_v2.schemas import DELETED_RESPONSE


def inject_subscriptions_routes(router, tags, prefix='/subscriptions'):
    router.post('%s/migrate' % prefix, tags=tags)(migrate_view)

    router.get(prefix, response=Collection[SubscriptionSchema], tags=tags)(get_subscriptions_view)
    router.post(prefix, response=SubscriptionSchema, tags=tags)(create_subscription_view)
    router.delete(prefix, response=DELETED_RESPONSE, tags=tags)(delete_subscriptions_view)
