from typing import List
from datetime import datetime

from ninja import Schema, Field

from wiki.api_v2.public.pages.page_identity import PageIdentity
from wiki.api_v2.public.pages.schemas import UserSchema
from wiki.subscriptions.consts import SubscriptionType


class SubscribedPageSchema(Schema):
    id: int
    title: str
    slug: str
    owner: UserSchema
    modified_at: datetime
    created_at: datetime
    is_active: bool


class SubscriptionSchema(Schema):
    id: int
    type: SubscriptionType
    page: SubscribedPageSchema
    is_cluster: bool
    created_at: datetime


class CreateSubscriptionSchema(Schema):
    page: PageIdentity
    is_cluster: bool


class DeleteSubscriptionsSchema(Schema):
    pages: List[PageIdentity]
    strict: bool = Field(
        default=False,
        description='Reject request if one of pages were not subscribed. Makes endpoint ' 'non-idempotent!',
    )


class MigrationSchema(Schema):
    force: bool = Field(False, description='For re-migration. Deletes all previously migrated subscriptions')
