from enum import Enum
from typing import Optional, List

from ninja import Schema
from wiki.api_v2.collections import Collection
from wiki.api_v2.schemas import Slug
from wiki.pages.models.consts import PageType


class NodeType(str, Enum):
    GAP = 'gap'
    LOCKED = 'locked'
    PAGE = 'page'
    COW = 'copy_on_write'


class NavTreeNodeSchema(Schema):
    id: Optional[int]
    slug: Slug
    title: str
    type: NodeType
    page_type: Optional[PageType]  # None if gap
    has_children: bool
    is_fixed: Optional[bool]


class NavTreeSchema(Schema):
    children: Collection[NavTreeNodeSchema]
    breadcrumbs_branch: Optional[List[NavTreeNodeSchema]]
