from wiki.api_v2.public.organization.views import (
    get_group_details_view,
    get_department_details_view,
    check_membership_view,
)
from wiki.api_v2.public.pages.schemas import GroupWithMembersSchema, CheckOrgMembershipSchema
from wiki.api_v2.router_factory import make_public_api_router

org_router = make_public_api_router(['organization'])

org_router.get('/groups/{group_id}', response=GroupWithMembersSchema)(get_group_details_view)
org_router.get('/departments/{group_id}', response=GroupWithMembersSchema)(get_department_details_view)
org_router.get('/check_membership', response=CheckOrgMembershipSchema)(check_membership_view)
