from wiki.api_v2.public.pages.access_requests.schemas import PageAccessRequestSchema
from wiki.api_v2.public.pages.access_requests.views import (
    get_access_request_view,
    create_access_request_view,
    process_access_request_view,
)


def inject_access_request_routes(router, tags, prefix='/{digit:idx}/access_requests'):
    router.post(prefix, tags=tags, response=PageAccessRequestSchema)(create_access_request_view)

    router.post(prefix + '/{int:access_request_id}/process', tags=tags, response=PageAccessRequestSchema)(
        process_access_request_view
    )

    router.get(prefix + '/{int:access_request_id}', tags=tags, response=PageAccessRequestSchema)(
        get_access_request_view
    )
