from wiki.api_v2.collections import Collection
from wiki.api_v2.public.pages.attachments.schemas import AttachFileResponse, AttachmentSchema
from wiki.api_v2.public.pages.attachments.views import (
    attach_file_view, attachments_view,
    delete_attach_view, download_by_file_id_view,
    preview_by_file_id_view,
)
from wiki.api_v2.schemas import DELETED_RESPONSE


def inject_attachment_routes(router, tags, prefix='/{idx}/attachments'):
    router.get(prefix, response=Collection[AttachmentSchema], tags=tags)(attachments_view)
    router.get('%s/{int:file_id}/download' % prefix, tags=tags)(download_by_file_id_view)
    router.post(prefix, response=AttachFileResponse, tags=tags)(attach_file_view)
    router.delete('%s/{int:file_id}' % prefix, response=DELETED_RESPONSE, tags=tags)(delete_attach_view)
    router.get('%s/{int:file_id}/preview' % prefix, tags=tags)(preview_by_file_id_view)
