from ninja import Schema
from pydantic import constr
from typing import List

from wiki.acl.check_access import filter_by_access
from wiki.api_v2.di import di, log_slug
from wiki.api_v2.public.pages.schemas import PageSchema
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.pages.models import Page


class AutoCompleteResponse(Schema):
    results: List[PageSchema]


@di
def autocomplete_view(request, organization: BaseOrganization, slug: constr(min_length=1)) -> AutoCompleteResponse:
    slug = slug.lstrip('/')
    depth = slug.count('/') + 1

    log_slug(request, slug=slug)

    pages = Page.active.filter(supertag__startswith=slug, org=organization.as_django_model(), depth=depth)

    return AutoCompleteResponse(
        results=[PageSchema.serialize(page) for page in filter_by_access(pages, request.user, organization)]
    )
