from typing import List

from ninja import Schema, Field

from django.conf import settings

from wiki.api_v2.di import di
from wiki.api_v2.public.pages.schemas import BackgroundSchema


class BackgroundsResponse(Schema):
    results: List[BackgroundSchema] = Field(..., description='Sorted by id')


@di
def backgrounds_view(request, organization) -> BackgroundsResponse:
    backgrounds = sorted(settings.PAGE_BACKGROUNDS, key=lambda x: x['id'])
    return BackgroundsResponse(results=[BackgroundSchema.parse_obj(bg) for bg in backgrounds])
