from wiki.acl.check_access import assert_has_access
from wiki.acl.consts import Action
from wiki.api_v2.di import di, log_slug
from wiki.api_v2.exceptions import BadRequest, IsStubPage
from wiki.api_v2.schemas import StatusOk
from wiki.api_v2.public.utils.get_object import get_page_or_404
from wiki.pages.constants import PageOrderPosition
from wiki.pages.exceptions import UpdatePagePositionError
from wiki.pages.logic.etalon import create_etalon_page
from wiki.pages.navigation_tree import update_node_position
from wiki.utils.supertag import normalize_supertag


@di
def change_order_view(
    request, organization, idx: int, next_to_slug: str, position: PageOrderPosition = PageOrderPosition.AFTER
) -> StatusOk:
    """
    В рамках одно раздела изменить порядок страницы
    """
    try:
        page = get_page_or_404(organization, pk=idx)
    except IsStubPage:
        page = create_etalon_page(organization, idx=idx)

    log_slug(request, slug=page.slug)
    assert_has_access(request.user, organization, page, Action.READ)
    next_to_slug = normalize_supertag(next_to_slug)
    try:
        update_node_position(page.supertag, position, next_to_slug, organization, request.user)
    except UpdatePagePositionError as e:
        raise BadRequest(str(e))

    return StatusOk()
