from wiki.api_v2.collections import Collection
from wiki.api_v2.public.pages.comments.views import (
    comments_view,
    get_comment_details_view,
    edit_comment_view,
    delete_comment_view,
    create_comment_view,
)
from wiki.api_v2.public.pages.schemas import CommentSchema
from wiki.api_v2.schemas import DELETED_RESPONSE


def inject_comment_routes(router, tags, prefix='/{digit:idx}/comments'):
    router.get(prefix, response=Collection[CommentSchema], tags=tags)(comments_view)
    router.post(prefix, response=CommentSchema, tags=tags)(create_comment_view)
    router.get('%s/{int:comment_id}' % prefix, response=CommentSchema, tags=tags)(get_comment_details_view)
    router.post('%s/{int:comment_id}' % prefix, response=CommentSchema, tags=tags)(edit_comment_view)
    router.delete('%s/{int:comment_id}' % prefix, response=DELETED_RESPONSE, tags=tags)(delete_comment_view)
