from wiki.api_v2.exceptions import BadRequest


class SlugOccupied(BadRequest):
    error_code = 'SLUG_OCCUPIED'
    debug_message = 'Requested slug is occupied by another page'


class SlugReserved(BadRequest):
    error_code = 'SLUG_RESERVED'
    debug_message = 'Requested slug is reserved'


class SlugTooLong(BadRequest):
    error_code = 'SLUG_TOO_LONG'
    debug_message = 'Requested slug is longer than 255. See details'


class SlugEmpty(BadRequest):
    error_code = 'SLUG_EMPTY'
    debug_message = 'Requested slug is empty'


class RedirectChain(BadRequest):
    error_code = 'REDIRECT_CHAIN'
    debug_message = 'Page redirects to another'


class PageReserved(BadRequest):
    error_code = 'PAGE_IS_RESERVED'
    debug_message = 'Page is protected from deletion (system or userhome)'


class NotMs365Page(BadRequest):
    error_code = 'NOT_MS365_PAGE'
    debug_message = 'Operation available only on Ms365 embed page'


class EmptyCustomAcl(BadRequest):
    error_code = 'EMPTY_CUSTOM_ACL'
    debug_message = 'Please provide at least one valid user or group'


class WrongFileExtension(BadRequest):
    error_code = 'WRONG_FILE_EXTENSION'


class DiffNotAvailable(BadRequest):
    error_code = 'DIFF_NOT_AVAILABLE_FOR_THE_TYPE'
    debug_message = 'Cant calculate diff for this type of page'


class PageBodySizeExceeded(BadRequest):
    error_code = 'PAGE_BODY_SIZE_EXCEEDED'
    debug_message = 'Page body size exceeded'


class IsCloudPage(BadRequest):
    error_code = 'IS_CLOUD_PAGE'
    debug_message = 'Operation not allowed for a cloud page'


class ClusterBlocked(BadRequest):
    error_code = 'CLUSTER_BLOCKED'
    debug_message = 'Cluster is blocked'


class UnknownLocation(BadRequest):
    error_code = 'UNKNOWN_LOCATION'
    debug_message = 'Unknown location'


class SectionNotFound(BadRequest):
    error_code = 'SECTION_NOT_FOUND'
    debug_message = 'Section not found'


class AnchorNotFound(BadRequest):
    error_code = 'ANCHOR_NOT_FOUND'
    debug_message = 'Anchor not found'
