from ninja import Schema

from wiki.api_v2.di import di, log_slug
from wiki.featured_pages.homepage import get_homepage_spa


class HomepageResponse(Schema):
    body: str


@di
def homepage_view(request, organization) -> HomepageResponse:
    log_slug(request, slug='homepage')
    return HomepageResponse(body=get_homepage_spa(request.user, organization))
