from wiki.api_v2.di import di, legacy_org_ctx
from wiki.async_operations.consts import OperationCreatedSchema, OperationType
from wiki.async_operations.operation_executors.move_cluster.consts import MoveClusterRequest
from wiki.async_operations.views import schedule_execution_view
from wiki.sync.connect.base_organization import BaseOrganization


@di
@legacy_org_ctx
def move_view(
    request,
    organization: BaseOrganization,
    data: MoveClusterRequest,
    dry_run: bool = False,
) -> OperationCreatedSchema:
    """
    Перенос страниц с подстраницами на новое место.

    Отложенная операция. Если все проверки пройдены, вернет информацию о том, как проверять статус и прогресс переноса

    Коды ошибок валидации (error_code)
    - `TOO_LONG_NAME`: новые пути будут слишком длинными.

        Подробности в поле `details.slugs = ['incorrect_slug', 'incorrect_slug_2']`
    - `CLUSTER_NOT_EXISTS`: источник не существует.
    - `CLUSTER_BLOCKED`: Кластер временно заблокирован для переноса.

        Подробности в поле `details.slugs = ['incorrect_slug', 'incorrect_slug_2']`
    - `OVERRIDE_ATTEMPT`: после переноса страницы пересекаются с уже существующими.

        Подробности в поле `details.slugs = ['incorrect_slug', 'incorrect_slug_2']`
    - `SOURCE_RESERVED`: нельзя переносить зарезервированные страницы.

        Подробности в поле `details.slugs = ['incorrect_slug', 'incorrect_slug_2']`
    - `DESTINATION_RESERVED`: нельзя переносить в зарезервированные страницы.

        Подробности в поле `details.slugs = ['incorrect_slug', 'incorrect_slug_2']`
    - `CLUSTER_PERMISSION_DENIED`: у пользователя который переносит кластер нет доступа к некоторым подстраницам.

       Подробности в поле `details.slugs = ['incorrect_slug', 'incorrect_slug_2']`
    - `BECOME_NOT_ACCESSIBLE`: после переноса у пользователя пропадет доступ к странице.
    - `NEXT_TO_HAS_WRONG_CLUSTER`: некорректная сортировка после переноса.
    - `NEXT_TO_NOT_EXISTS`: страница, для расчета сортировки, не существует.
    - `NEXT_TO_NOT_SET`: В случае, если адрес страницы не изменяется, а страница, для расчета сортировки, не указана.
    - `NEXT_TO_WILL_MOVE`: Страница, для расчета сортировки, будет перемещена в этой же операции.
    - `OPERATION_LIMIT_EXCEEDED`: Количество операций превысило лимит, равный 100
    """

    return schedule_execution_view(request, organization, data, OperationType.MOVE_CLUSTER, dry_run=dry_run)
