from wiki.acl.check_access import assert_has_access
from wiki.acl.consts import Action
from wiki.api_v2.default_exception_handlers import upgrade_legacy_api_exceptions
from wiki.api_v2.di import di, log_slug
from wiki.api_v2.public.pages.exceptions import NotMs365Page
from wiki.api_v2.public.pages.schemas import CheckAccessResponse
from wiki.api_v2.public.utils.get_object import get_page_or_404
from wiki.integrations.ms.utils import get_doc_retriever_client
from wiki.pages.models import CloudPage
from wiki.sync.connect.base_organization import BaseOrganization


@di
@upgrade_legacy_api_exceptions
def check_m365_access_view(request, organization: BaseOrganization, idx: int) -> CheckAccessResponse:
    """
    Проверяем есть ли у пользователя доступ к документу из sharepoint - не обязательно
    которым управляет вики. Это нужно чтобы отобразить плашку "нет доступа" т.к.
    в iframe 403 старница шейрпойнта режется по x-frame-options
    """

    page = get_page_or_404(organization, pk=idx)
    log_slug(request, slug=page.slug)
    assert_has_access(request.user, organization, page, Action.READ)

    if page.page_type != page.TYPES.CLOUD:
        raise NotMs365Page()

    cloud_page: CloudPage = CloudPage.objects.get(page_id=page.id)
    src = cloud_page.get_cloud_src()

    client = get_doc_retriever_client()
    cloud_result = client.check_access(
        request.user.username, src.embedding.domain, src.embedding.namespace, src.embedding.sourcedoc
    )

    return CheckAccessResponse.parse_obj(cloud_result)
