from wiki.acl.check_access import assert_has_access
from wiki.acl.consts import Action
from wiki.api_v2.default_exception_handlers import upgrade_legacy_api_exceptions
from wiki.api_v2.di import di, log_slug
from wiki.api_v2.public.pages.exceptions import NotMs365Page
from wiki.api_v2.public.pages.page.schemas import LinkResponse
from wiki.api_v2.public.utils.get_object import get_page_or_404
from wiki.integrations import get_page_provider
from wiki.pages.models import CloudPage
from wiki.sync.connect.base_organization import BaseOrganization


@di
@upgrade_legacy_api_exceptions
def download_ms365_source_view(request, organization: BaseOrganization, idx: int) -> LinkResponse:
    """
    Отредиректит на временную ссылку на скачивание исходника офисного документа
    """

    page = get_page_or_404(organization, pk=idx)
    log_slug(request, slug=page.slug)
    assert_has_access(request.user, organization, page, Action.READ)

    if page.page_type != page.TYPES.CLOUD:
        raise NotMs365Page()

    cloud_page = CloudPage.objects.get(page_id=page.id)
    page_provider = get_page_provider(cloud_page.provider)
    download_url = page_provider.get_download_url(cloud_page)
    return LinkResponse(url=download_url)
