from ninja import Query

from wiki.api_v2.collections import MediumPaginationQuery
from wiki.api_v2.di import di, legacy_org_ctx, log_slug
from wiki.api_v2.public.pages.schemas import NavigationTreeSchema
from wiki.pages.navigation_tree import NavigationTree
from wiki.utils.supertag import normalize_supertag


@di
@legacy_org_ctx
def navigation_tree_view(
    request, organization, slug: str, pagination: MediumPaginationQuery = Query(...)
) -> NavigationTreeSchema:
    """
    View для получение данных для дерева навигации, отдает список дочерних страниц первого уровня.
    """
    log_slug(request, slug=slug)
    slug = normalize_supertag(slug)
    tree = NavigationTree(
        slug,
        request.user,
        organization,
        pagination.page_id,
        pagination.page_size,
    )

    return tree.build_tree()
