from wiki.api_v2.public.pages.page.consts import OperationResult
from wiki.api_v2.public.pages.page.schemas import CreatePageSchema
from wiki.grids.models import Grid, Revision
from wiki.pages.models.consts import PAGE_TYPE_TO_DB_MAP
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.utils import timezone


def create_grid(user, user_auth, organization: BaseOrganization, data: CreatePageSchema) -> OperationResult:
    page = Grid(
        title=data.title,
        page_type=PAGE_TYPE_TO_DB_MAP[data.page_type],
        tag=data.slug,
        supertag=data.slug,
        owner=user,
        org=organization.as_django_model(),
        last_author=user,
        modified_at=timezone.now(),
    )
    page.access_structure['title'] = data.title
    page.access_structure['sorting'] = []
    page.change_structure(plain_structure=None, already_parsed=page.access_structure)
    page.save()
    page.authors.add(user)
    revision = Revision.objects.create_from_page(page)
    return OperationResult(page_created=True, page=page, revision=revision)
