from wiki.api_v2.public.pages.page.consts import OperationResult
from wiki.api_v2.public.pages.page.schemas import CreatePageSchema
from wiki.pages.models import Page, Revision
from wiki.pages.models.consts import PAGE_TYPE_TO_DB_MAP
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.utils import timezone


def create_page(user, user_auth, organization: BaseOrganization, data: CreatePageSchema) -> OperationResult:
    page = Page(
        title=data.title,
        page_type=PAGE_TYPE_TO_DB_MAP[data.page_type],
        tag=data.slug,
        supertag=data.slug,
        owner=user,
        org=organization.as_django_model(),
        last_author=user,
        modified_at=timezone.now(),
    )
    page.body = data.content or ''
    page.save()
    page.authors.add(user)
    revision = Revision.objects.create_from_page(page)
    return OperationResult(page_created=True, page=page, revision=revision)
