from wiki.acl.check_access import assert_has_access
from wiki.acl.consts import Action
from wiki.api_v2.di import di, legacy_org_ctx, log_slug
from wiki.api_v2.exceptions import IsStubPage
from wiki.api_v2.public.pages.exceptions import PageReserved
from wiki.api_v2.public.pages.page.sideeffects import apply_sideeffects_on_page_delete
from wiki.api_v2.public.utils.get_object import get_page_or_404
from wiki.api_v2.schemas import DELETED
from wiki.pages.constants import ReservedDeletionError
from wiki.pages.logic.etalon import get_etalon_page
from wiki.pages.utils.remove import delete_page
from wiki.sync.connect.base_organization import BaseOrganization
from django.db import transaction


@di
@legacy_org_ctx
@transaction.atomic()
def delete_page_view(
    request,
    organization: BaseOrganization,
    idx: int,
) -> DELETED:
    try:
        page = get_page_or_404(organization, pk=idx)
    except IsStubPage:
        page = get_etalon_page(organization, idx=idx)

    log_slug(request, slug=page.slug)
    assert_has_access(request.user, organization, page, Action.DELETE)

    try:
        delete_page(page)
    except ReservedDeletionError:
        raise PageReserved()

    apply_sideeffects_on_page_delete(page, request.user)
    return DELETED
