ORDER_ATTR = '__preserve_order'


def store_order(model, attr_name, values):
    if not hasattr(model, ORDER_ATTR):
        setattr(model, ORDER_ATTR, {})

    storage = getattr(model, ORDER_ATTR)
    storage[attr_name] = {o.pk: idx for idx, o in enumerate(values)}


def restore_order(model, attr_name, values):
    if not hasattr(model, ORDER_ATTR):
        return values

    storage = getattr(model, ORDER_ATTR)

    if attr_name not in storage:
        return values

    order = storage[attr_name]

    max_len = len(order) + 10

    return sorted(values, key=lambda obj: order.get(obj.pk, max_len))
