from wiki.acl.check_access import assert_has_access
from wiki.acl.consts import Action
from wiki.api_frontend.views.access import validate_acl_request, apply_legacy_acl, apply_legacy_acl_sideeffects
from wiki.api_v2.public.pages.page.schemas import AclUpdateSchema
from wiki.pages.access.utils import get_legacy_acl, convert_acl_request_to_legacy_acl
from wiki.pages.models import Page
from wiki.sync.connect.base_organization import BaseOrganization


def set_acl(user, organization: BaseOrganization, page: Page, data: AclUpdateSchema, is_silent: bool = False):
    """
    Валидация проходит в самой модели
    """

    assert_has_access(user, organization, page, Action.CHANGE_ACL, message='ACL change requires elevated permissions')

    if data.affects_page_model:
        page.is_readonly = data.is_readonly

    if data.affects_acl:
        current_acl = get_legacy_acl(page)
        desired_acl = convert_acl_request_to_legacy_acl(data)
        validate_acl_request(user, current_acl, desired_acl)

        apply_legacy_acl(page, user, desired_acl)

    if data.affects_acl or data.affects_page_model:
        apply_legacy_acl_sideeffects(page)

    return False
