from wiki.api_v2.public.pages.page.schemas import ActualityUpdateSchema
from wiki.api_v2.public.pages.page_identity import resolve_page_identities
from wiki.pages.logic.actuality import mark_page_actuality

from wiki.pages.models import Page
from wiki.sync.connect.base_organization import BaseOrganization


def update_actuality_schema(
    user, organization: BaseOrganization, page: Page, data: ActualityUpdateSchema, is_silent: bool = False
):
    actual_pages = []
    # в бизнес-логике жосткий ассерт что при obsolete ему ничего не передают
    if data.actual_pages and not data.is_actual:
        actual_pages = resolve_page_identities(organization, data.actual_pages)

    mark_page_actuality(
        user=user,
        page=page,
        is_actual=data.is_actual,
        comment=data.comment,
        actual_pages=actual_pages,
        external_links=data.external_links,
    )
    return False
