from typing import Optional

from django.conf import settings

from wiki.api_v2.exceptions import NotFound
from wiki.pages.models import Page


def update_background(user, organization, page: Page, background_id: Optional[int], is_silent: bool = False):
    if background_id is None:
        page.background_id = None
    elif background_id in settings.PAGE_BACKGROUNDS_IDS:
        page.background_id = background_id
    else:
        raise NotFound('Background not found by id')
