from wiki.api_v2.exceptions import BadRequest
from wiki.api_v2.public.pages.page.schemas import RedirectUpdateSchema
from wiki.api_v2.public.pages.page_identity import resolve_page_identity
from wiki.pages.logic import redirect as redirect_logic
from wiki.pages.models import Page, RedirectLoopException
from wiki.sync.connect.base_organization import BaseOrganization


class RedirectLoop(BadRequest):
    error_code = 'REDIRECT_LOOP'
    debug_message = 'Failed to create redirect. Target page already redirects to current page.'


def update_redirect_schema(
    user, organization: BaseOrganization, page: Page, data: RedirectUpdateSchema, is_silent: bool = False
):
    try:
        if data.page:
            dest = resolve_page_identity(organization, data.page)
            redirect_logic.set_redirect(page, user, dest)
        else:
            redirect_logic.remove_redirect(page, user)
    except RedirectLoopException:
        raise RedirectLoop

    return False
