from wiki.api_v2.collections import Collection
from wiki.api_v2.public.pages.revisions.schemas import DiffSchema
from wiki.api_v2.public.pages.revisions.views import revisions_view, diff_view
from wiki.api_v2.public.pages.schemas import RevisionSchema


def inject_revisions_routes(router, tags, prefix):
    router.get(prefix, response=Collection[RevisionSchema], tags=tags)(revisions_view)
    router.get('%s/diff' % prefix, response=DiffSchema, tags=tags)(diff_view)
