from datetime import datetime
from typing import List, Any, Literal, Union

from ninja import Schema

from wiki.api_v2.public.pages.schemas import UserSchema
from wiki.pages.models.consts import PageType


class RevisionDetailsSchema(Schema):
    id: int
    content: str
    title: str
    author: UserSchema
    created_at: datetime


class PageDiffSchema(Schema):
    diff: List[Any]
    type: Literal[PageType.REGULAR_PAGE] = PageType.REGULAR_PAGE


class WysiwygDiffSchema(Schema):
    diff: List[Any]
    type: Literal[PageType.WYSIWYG] = PageType.WYSIWYG


class GridDiffSchema(Schema):
    diff: Any
    column_titles: Any
    type: Literal[PageType.GRID] = PageType.GRID


class DiffSchema(Schema):
    title: str
    content: Union[PageDiffSchema, WysiwygDiffSchema, GridDiffSchema]
