from wiki.api_v2.collections import Collection
from wiki.api_v2.public.pages.subscribers.schemas import AddSubscribersResponse, SubscriberSchema
from wiki.api_v2.public.pages.subscribers.views import (
    add_subscribers_view,
    get_subscribers_view,
    delete_subscriber_view,
)
from wiki.api_v2.schemas import DELETED_RESPONSE


def inject_subscribers_routes(router, tags, prefix='/{digit:idx}/subscribers'):
    router.get(prefix, response=Collection[SubscriberSchema], tags=tags)(get_subscribers_view)
    router.post(prefix, response=AddSubscribersResponse, tags=tags)(add_subscribers_view)
    router.delete('%s/{int:subscription_id}' % prefix, response=DELETED_RESPONSE, tags=tags)(delete_subscriber_view)
