from typing import List

from ninja import Schema
from pydantic import conlist, Field

from wiki.api_frontend.serializers.user_identity import UserIdentity
from wiki.api_v2.public.pages.schemas import UserSchema


class SubscriberSchema(Schema):
    id: int
    is_cluster: bool
    user: UserSchema


class AddSubscribersSchema(Schema):
    users: conlist(UserIdentity, min_items=1, max_items=50)
    is_cluster: bool
    message: str = ''


class AddSubscribersResponse(Schema):
    results: List[SubscriberSchema] = Field(default_factory=list)
