from wiki.api_v2.public.diagnostic_views import validation_smoke_view
from wiki.api_v2.public.grids.router import grid_router
from wiki.api_v2.public.organization.router import org_router
from wiki.api_v2.public.me.router import me_router
from wiki.api_v2.public.pages.router import page_router
from wiki.api_v2.public.upload_sessions.router import upload_session_router
from wiki.api_v2.public.navigation_tree.router import navtree_router
from wiki.api_v2.public.users.router import user_router
from wiki.api_v2.router_factory import make_public_api_router

from wiki.async_operations.router import op_router

public_api = make_public_api_router()

public_api.post('/diag/validate_me', include_in_schema=False)(validation_smoke_view)

public_api.add_router('/pages', page_router)
public_api.add_router('/users', user_router)
public_api.add_router('/navtree', navtree_router)
public_api.add_router('/me', me_router)
public_api.add_router('/organization', org_router)
public_api.add_router('/operations', op_router)
public_api.add_router('/upload_sessions', upload_session_router)
public_api.add_router('/grids', grid_router)
