from wiki.api_v2.exceptions import NotFound, BadRequest


class UploadSessionNotFound(NotFound):
    error_code = 'UPLOAD_SESSION_NOT_FOUND'


class UploadSessionLimitExceeded(BadRequest):
    error_code = 'UPLOAD_SESSION_LIMIT_EXCEEDED'


class UploadSessionFileSizeLimit(BadRequest):
    error_code = 'UPLOAD_SESSION_FILE_SIZE_LIMIT'


class UploadSessionInProgressError(BadRequest):
    error_code = 'UPLOAD_SESSION_IN_PROGRESS_ERROR'


class MalformedUploadSessionRequest(BadRequest):
    error_code = 'MALFORMED_UPLOAD_REQUEST'


class StorageUploadError(BadRequest):
    error_code = 'STORAGE_UPLOAD_ERROR'
    debug_message = 'See details for inner code'

    @classmethod
    def from_aws(cls, client_error):
        original_error = client_error.response.get('Error', {})

        # Оставим только "безопасные" поля
        original_error = {k: v for k, v in original_error.items() if k in {'Code', 'Message'}}

        return cls(details={'original_error': original_error})


class InvalidUploadSession(BadRequest):
    error_code = 'INVALID_UPLOAD_SESSION'
