from wiki.api_v2.public.upload_sessions.schemas import UploadSessionSchema
from wiki.api_v2.public.upload_sessions.views import (
    get_upload_session_view,
    create_upload_session_view,
    upload_part_view,
    complete_multipart_upload_view,
    abort_multipart_upload_view,
    abort_all_view,
)
from wiki.api_v2.router_factory import make_public_api_router
from wiki.api_v2.schemas import StatusOk

upload_session_router = make_public_api_router(['upload_sessions'])

upload_session_router.post('', response=UploadSessionSchema)(create_upload_session_view)
upload_session_router.post('/abort_active_uploads', response=StatusOk)(abort_all_view)
upload_session_router.get('/{uuid:session_id}', response=UploadSessionSchema)(get_upload_session_view)
upload_session_router.put('/{uuid:session_id}/upload_part', response=UploadSessionSchema)(upload_part_view)
upload_session_router.post('/{uuid:session_id}/finish', response=UploadSessionSchema)(complete_multipart_upload_view)
upload_session_router.post('/{uuid:session_id}/abort', response=UploadSessionSchema)(abort_multipart_upload_view)
