from typing import List

from ninja import Schema
from pydantic import Field

from wiki.api_frontend.serializers.user_identity import UserIdentity
from wiki.api_v2.public.pages.schemas import UserSchema


class UserLoginsSchema(Schema):
    logins: List[str] = Field(min_items=1, description='Список логинов и/или email-ов')


class UserIdentitiesSchema(Schema):
    identities: List[UserIdentity] = Field(min_items=1)


class UsersResponse(Schema):
    users: List[UserSchema]
