from wiki.api_frontend.views.resolve_user_by_login import divide_by_logins_and_emails, get_users_by_logins_and_emails
from wiki.api_v2.di import di
from wiki.api_v2.public.users.schemas import UserLoginsSchema, UserIdentitiesSchema, UsersResponse
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.users.dao import get_users_by_identity
from wiki.users.user_data_repository import USER_DATA_REPOSITORY


@di
def resolve_users_logins_view(request, organization: BaseOrganization, data: UserLoginsSchema) -> UsersResponse:
    """
    Получить информацию о пользователях по `login`, `login@domain` или `login:domain`
    """

    logins, emails = divide_by_logins_and_emails(data.logins)
    users = get_users_by_logins_and_emails(logins, emails, organization=organization)

    return UsersResponse(users=[USER_DATA_REPOSITORY.orm_to_user_schema(user) for user in users])


@di
def resolve_users_identities_view(request, organization: BaseOrganization, data: UserIdentitiesSchema) -> UsersResponse:
    """
    Получить информацию о пользователях по `uid` или `cloud_uid`
    """

    users = get_users_by_identity(
        data.identities, panic_if_missing=True, prefetch_staff=True, organization=organization, apiv1_exceptions=False
    )

    return UsersResponse(users=[USER_DATA_REPOSITORY.orm_to_user_schema(user) for user in users])
