from django.conf import settings

from wiki.api_v2.exceptions import NotFound, BadRequest, IsStubPage
from wiki.pages.models import Page
from wiki.sync.connect.base_organization import BaseOrganization


def get_page_or_404(organization: BaseOrganization, *args, **kwargs) -> Page:
    try:
        return organization.get_active_pages().get(*args, **kwargs)
    except Page.DoesNotExist:
        pk, slug = kwargs.get('pk'), kwargs.get('supertag')
        if (pk and pk in settings.COPY_ON_WRITE_IDS) or (slug and slug in settings.COPY_ON_WRITE_TAGS):
            raise IsStubPage()

        raise NotFound()


def get_page_or_none(organization: BaseOrganization, *args, **kwargs) -> Page | None:
    try:
        return organization.get_active_pages().get(*args, **kwargs)
    except Page.DoesNotExist:
        return None


def get_page_or_400(organization: BaseOrganization, msg='Not found', *args, **kwargs) -> Page:
    try:
        return organization.get_active_pages().get(*args, **kwargs)
    except Page.DoesNotExist:
        raise BadRequest(msg)
