from ninja import Router
from wiki.api_v2.auth import private_auth, support_auth, public_auth


def make_public_api_router(tags=None) -> Router:
    return Router(auth=public_auth, tags=tags or ['public'])


def make_support_api_router(tags=None) -> Router:
    return Router(auth=support_auth, tags=tags or ['support_api'])


def make_private_api_router(tags=None) -> Router:
    return Router(auth=private_auth, tags=tags or ['private'])
