from django.urls import register_converter, path

from wiki.api_v2.api import ninja_api


class DigitIntConverter:
    """For matching negative numbers"""

    regex = r'-?\d+'

    @staticmethod
    def to_python(value):
        return int(value)

    @staticmethod
    def to_url(value):
        return str(value)


register_converter(DigitIntConverter, 'digit')

urlpatterns = [path('', ninja_api.urls)]
