import io
import logging
import os
from functools import partial
from typing import Any

is_arcadia = False
is_arcadia_test = False

try:
    from library.python import resource  # noqa

    is_arcadia = True
except ImportError:
    pass

try:
    import library.python.testing.recipe  # noqa

    if library.python.testing.recipe.ya:  # noqa
        is_arcadia_test = True
except (ImportError, AttributeError):
    pass

logger = logging.getLogger(__name__)


def read_asset(filename) -> bytes:
    if is_arc():
        return resource.resfs_read(filename)
    else:
        return open(filename, 'rb').read()


def read_asset_as_stream(filename):
    data = read_asset(filename)

    if not data:
        raise ValueError(f'Asset {filename} not found')

    return io.BytesIO(data)


def is_arc():
    return is_arcadia


def is_arc_runtime_testing():
    return is_arcadia_test


UNSET = object()

trueish = frozenset(['1', 'y', 'true', 'True', 'TRUE'])
falseish = frozenset(['0', 'n', 'false', 'False', 'FALSE'])


def ext_bool(inp: str) -> bool:
    if inp in trueish:
        return True
    if inp in falseish:
        return False
    logger.error(f'Cant treat {inp} as bool')
    raise ValueError(f'Cant treat {inp} as bool')


def env(key: str, default: Any = UNSET, cast_as: Any = str):
    """
    Временный хелпер, до того момента как мы переедем на что-то нормальное
    отказавшись от granular_settings
    :param key:
    :param cast_as:
    :param default:
    :return:
    """
    if cast_as == bool:
        cast_as = ext_bool
    for key_variant in (key, key.upper()):
        if key_variant in os.environ:
            return cast_as(os.environ[key_variant])
    if default is UNSET:
        logger.error(f'{key_variant} is not set!')
        raise ValueError(f'{key_variant} is not set!')
    else:
        return default


env_str = partial(env, cast_as=str)
env_int = partial(env, cast_as=int)
env_bool = partial(env, default=False, cast_as=bool)
