from wiki.api_core.errors.rest_api_error import BadRequest
from wiki.api_v2.exceptions import BadRequest as BadRequestNew


class PreconditionsFailed(BadRequest):
    error_code = 'PRECONDITIONS_FAILED'
    debug_message = 'Preconditions failed for given task'

    @classmethod
    def from_new_api_exception(cls, new_exception: BadRequestNew):
        old_exception = cls()

        if new_exception.error_code:
            old_exception.error_code = new_exception.error_code
        if new_exception.debug_message:
            old_exception.debug_message = new_exception.debug_message
        if new_exception.details:
            old_exception.details = new_exception.details

        return old_exception


class AlreadyRunning(BadRequest):
    error_code = 'ALREADY_RUNNING'
    debug_message = 'Task with given id already in execution'


class OperationNotFound(ValueError):
    debug_message = 'Task with given id not found'
