from ninja import Schema, Field

from wiki.api_v2.public.pages.page_identity import PageIdentity
from wiki.api_v2.public.pages.schemas import PageSchema
from wiki.api_v2.schemas import Slug, NotEmptyStringTrimmed


class PageCloneRequest(Schema):
    target: Slug = Field(description='slug страницы после копирования')
    title: NotEmptyStringTrimmed | None = Field(description='Если передан, название страницы после копирования')
    subscribe_me: bool = Field(default=False, description='Подписатьcя на изменения')


class PageCloneResponse(Schema):
    page: PageSchema = Field(description='Клонированная страница')


class PageClone(Schema):
    page: PageIdentity
    data: PageCloneRequest
