import hashlib
import logging
import time

from wiki.async_operations.consts import OperationType, OperationIdentity
from wiki.async_operations.exceptions import PreconditionsFailed
from wiki.async_operations.models import TestTaskParams
from wiki.async_operations.operation_executors.base import BaseOperation
from wiki.async_operations.operation_executors.debug_operation.consts import TestTaskResult
from wiki.async_operations.progress_storage import ProgressStorage

logger = logging.getLogger(__name__)


class TestAsyncOperation(BaseOperation[TestTaskParams, TestTaskResult]):
    TASK_TYPE = OperationType.TEST

    arg_class = TestTaskParams
    result_class = TestTaskResult

    def check_preconditions(self):
        if self.args.number < 0:
            raise PreconditionsFailed()

    def _execute(self, reporter: ProgressStorage):
        logger.info('inside _execute in my test operation')
        for i in range(self.args.number):
            reporter.report_progress(self.get_task_identity(), i / self.args.number, 'executing...')
            if self.args.sleep:
                time.sleep(5 / self.args.number)
        reporter.report_progress(self.get_task_identity(), 1, 'finished')
        return TestTaskResult(number=self.args.number)

    def generate_task_identity(self) -> OperationIdentity:
        return OperationIdentity(
            type=self.TASK_TYPE,
            id=hashlib.md5(
                f'{self.owner.org_inner_id} | {self.args.number} | {self.args.sleep} | {self.owner.user_id}'.encode(
                    'utf-8'
                )
            ).hexdigest(),
        )
