from wiki.api_core.errors.permissions import UserHasNoAccess
from wiki.api_core.framework import WikiAPIView
from wiki.api_core.raises import raises
from wiki.async_operations.consts import OperationOwner
from wiki.async_operations.models import TestTaskParams
from wiki.async_operations.operation_executors.debug_operation.debug_operation import TestAsyncOperation
from wiki.async_operations.tasks.execute_async_operation import drf_view_schedule_execution
from wiki.async_operations.views import logger
from wiki.sync.connect.org_ctx import get_org_id
from rest_framework import serializers
from rest_framework.response import Response


class TestAsyncOpSerializer(serializers.Serializer):
    number = serializers.IntegerField(default=1000)
    sleep = serializers.BooleanField(default=True)


class TestAsyncOperationView(WikiAPIView):
    serializer_class = serializers.Serializer

    @raises()
    def post(self, request, *args, **kwargs):
        """
        Warning: This is a test operation, that actually do nothing

        Example: https://wiki-api.yandex-team.ru/_api/frontend/.async_operations/test?number=1000
        """
        if self.request.user.is_anonymous:
            raise UserHasNoAccess()

        logger.info('prepare to start test async op')

        serializer = TestAsyncOpSerializer(data=request.data)
        serializer.is_valid(raise_exception=True)

        params = TestTaskParams(
            **serializer.validated_data,
        )
        owner = OperationOwner(org_inner_id=get_org_id(), user_id=request.user.id)

        my_async_op = TestAsyncOperation(params, owner)
        task_id = drf_view_schedule_execution(my_async_op)

        return Response({'task_id': task_id}, 200)
