from ninja import Schema
from pydantic import Field

from wiki.api_v2.schemas import Slug
from wiki.pages.constants import PageOrderPosition


class MoveCluster(Schema):
    source: Slug = Field(description='slug страницы до переноса')
    target: Slug = Field(description='slug страницы после переноса')

    next_to_slug: Slug | None = Field(description='Задать порядок страницы в кластере после переноса')
    position: PageOrderPosition | None = Field(description='Задать порядок страницы в кластере после переноса')


class MoveClusterLegacy(MoveCluster):
    with_children: bool

    next_to_slug: type(None) = None
    position: type(None) = None


class MoveClusterRequest(Schema):
    operations: list[MoveCluster] = Field(min_items=1, description='Последовательный список операций переноса страниц')


class MoveClusterRequestWithLegacy(MoveClusterRequest):
    operations: list[MoveClusterLegacy] | list[MoveCluster] = Field(min_items=1)


class MoveClusterResponse(Schema):
    page_count: int
