from django.utils.translation import ugettext_lazy

from wiki.api_v2.exceptions import BadRequest

TOO_LONG_NAME = 'TOO_LONG_NAME'
CLUSTER_NOT_EXISTS = 'CLUSTER_NOT_EXISTS'
OVERRIDE_ATTEMPT = 'OVERRIDE_ATTEMPT'
SOURCE_RESERVED = 'SOURCE_RESERVED'
DESTINATION_RESERVED = 'DESTINATION_RESERVED'
CLUSTER_PERMISSION_DENIED = 'CLUSTER_PERMISSION_DENIED'
BECOME_NOT_ACCESSIBLE = 'BECOME_NOT_ACCESSIBLE'
NEXT_TO_HAS_WRONG_CLUSTER = 'NEXT_TO_WRONG_CLUSTER'
NEXT_TO_NOT_EXISTS = 'NEXT_TO_NOT_EXISTS'
NEXT_TO_NOT_SET = 'NEXT_TO_NOT_SET'
NEXT_TO_WILL_MOVE = 'NEXT_TO_WILL_MOVE'
CLUSTER_BLOCKED = 'CLUSTER_BLOCKED'
OPERATION_LIMIT_EXCEEDED = 'OPERATION_LIMIT_EXCEEDED'
SLUG_IS_FIXED = 'SLUG_IS_FIXED'

MESSAGES = {
    TOO_LONG_NAME: ugettext_lazy('Given names was too long'),
    CLUSTER_NOT_EXISTS: ugettext_lazy('Given cluster does not exist'),
    OVERRIDE_ATTEMPT: ugettext_lazy('Destination pages already exists'),
    SOURCE_RESERVED: ugettext_lazy('Some of source pages are reserved'),
    DESTINATION_RESERVED: ugettext_lazy('Some of destination pages are reserved'),
    CLUSTER_PERMISSION_DENIED: ugettext_lazy('You have no access to the source cluster'),
    BECOME_NOT_ACCESSIBLE: ugettext_lazy('Parent of destination cluster is not accessible'),
    NEXT_TO_HAS_WRONG_CLUSTER: ugettext_lazy('Next to slug cluster is different from destination'),
    NEXT_TO_NOT_EXISTS: ugettext_lazy('Next to slug cluster page does not exist'),
    NEXT_TO_NOT_SET: ugettext_lazy('Next to slug cluster not set, If the page name is not changed'),
    NEXT_TO_WILL_MOVE: ugettext_lazy('Next to slug page will move'),
    CLUSTER_BLOCKED: ugettext_lazy('Some parent of source or destination cluster is currently blocked'),
    OPERATION_LIMIT_EXCEEDED: ugettext_lazy('The number of operations exceeded the limit'),
    SLUG_IS_FIXED: ugettext_lazy('The page is fixed and cannot be moved'),
}


def bad_request_helper(error_code: str = None, details: ... = None):
    return BadRequest(debug_message=str(MESSAGES[error_code]), error_code=error_code, details=details)
