from wiki.api_v2.router_factory import make_public_api_router
from wiki.async_operations.consts import AsyncOperationStatusSchema
from wiki.async_operations.operation_executors.debug_operation.view import test_async_operation_view
from wiki.async_operations.operation_executors.registry import EXECUTOR_REGISTRY
from wiki.async_operations.views import make_operation_status_view

op_router = make_public_api_router(['operations'])

for op_type, op in EXECUTOR_REGISTRY.items():
    url = '/%s/{task_id}' % op_type.value
    op_router.get(url, response=AsyncOperationStatusSchema[op.result_class], exclude_unset=True)(
        make_operation_status_view(op_type, op.result_class)
    )

op_router.post('/counter')(test_async_operation_view)
